"Libation bearers" by "Victor Gijsbers"

Include Simple Chat by Mark Tilford. Use Default Forbid Exiting Conversations.
Include Basic Screen Effects by Emily Short.


When play begins:
	say "Orestes, wake up! Wake up, son of Agamemnon! And be of good cheer, for the day of your dreams has finally come.";
	now the numbers boolean is false.
	





[HERE START SOME MISCELLANEOUS TWEAKS I REUSE FROM GAME TO GAME.]

Section - Miscellaneous Tweaks

[Take all responses]

[We dont' want "take all" to include scenery or persons.]

Rule for deciding whether all includes scenery: it does not.
Rule for deciding whether all includes persons: it does not.

[I want "x here" to be synonymous to look.]

The here-backdrop is a backdrop. Here-backdrop is everywhere. Understand "here" as the here-backdrop. Instead of examining here-backdrop: try looking.

[This is here just to make testing easier.]

The test key strokes boolean is a truth state that varies. The test key strokes boolean is [true]false.

To test for any key:
	if the test key strokes boolean is true, wait for any key.

[Some style shortcuts.]

To say rpo:
	say "[run paragraph on]".

To say i:
	say "[italic type]".
	
To say r:
	say "[roman type]".

To say b:
	say "[bold type]".

To say pb:
	say "[paragraph break]".

To say lb:
	say "[line break]".
	
To say lbr:
	say "[bracket]".

To say rbr:
	say "[close bracket]".





[HERE STARTS INFORM ATTACK]


Volume - Inclusions, programming variables and tricks

Include Plurality by Emily Short.
Include Dice-lock by S John Ross.

Before doing anything: lock the dice.

Use no scoring, full-length room descriptions[ and undo prevention].

Use MAX_OBJ_PROP_COUNT of 128. [Because we define way more than 64  properties for persons/monsters!]
[Use MAX_PROP_TABLE_SIZE of 50000.]

Use MAX_STATIC_DATA of 300000.
[Use dynamic memory allocation of at least 30000.]

[Use Default Forbid Exiting Conversations. [Simple Chat]]


When play begins, seed the random-number generator with 81.


To decide which number is the current_row: (- ct_1 -).




Volume - The Main System

[The Main System covers the basics of combat, and creates rulebooks for all other systems to fit into.]


Book - Minor Preliminaries


Chapter - Saying things

[This variable determines whether we get to see numerical output.]

The numbers boolean is a truth state that varies. The numbers boolean is usually true.

Switching the numbers off is an action out of world. Understand "numbers off" as switching the numbers off.

Carry out switching the numbers off:
	now the numbers boolean is false;
	say "You will no longer see combat-related numbers.".

Switching the numbers on is an action out of world. Understand "numbers on" as switching the numbers on.

Carry out switching the numbers on:
	now the numbers boolean is true;
	say "You will now see combat-related numbers.".



[These two phrases are used to refer to the Health score. Change them to rename the Health score.]

To say capital health:
	say "Health".

To say health:
	say "health".


[I want "you", not "yourself".]

Rule for printing the name of yourself:
	say "you".

[But we'll need to have tokens that print "You" rather than "you". For this reason, the following.]

To say CAP-attacker:
	if the global attacker is the player begin;
		say "[The global attacker]" in sentence case;
	otherwise;
		say "[The global attacker]";
	end if.

To say CAP-defender:
	if the global defender is the player begin;
		say "[The global defender]" in sentence case;
	otherwise;
		say "[The global defender]";
	end if.

The global actor is a person that varies.

To say CAP-actor:
	if the global actor is the player begin;
		say "[The global actor]" in sentence case;
	otherwise;
		say "[The global actor]";
	end if.

To say CAP-noun:
	if the noun is the player begin;
		say "[The noun]" in sentence case;
	otherwise;
		say "[The noun]";
	end if.

To say CAP-second noun:
	if the second noun is the player begin;
		say "[The second noun]" in sentence case;
	otherwise;
		say "[The second noun]";
	end if.


Chapter - Global variables


The first dummy, the second dummy, the third dummy and the fourth dummy are numbers that vary.



Chapter - Time

[Some of the actions should take no time; we wish to ensure that examining, smelling, and so on do not take a combat turn. This will allow the player to look around in combat, which is to be encouraged.]

Examining something is acting fast.
Taking inventory is acting fast.
Smelling is acting fast.
Smelling something is acting fast.
Looking is acting fast.
Looking under something is acting fast.
Listening is acting fast.
Listening to something is acting fast.
Thinking is acting fast.


First turn sequence rule: if acting fast, rule succeeds.

To take no time:
    (- meta = true; -).




Book - Dressing up the Person Class

Chapter - Health

A person has a number called health. The health of a person is usually 10. [health is a measure of health.]

Definition: A person is alive if its health is 1 or more. Definition: A person is killed if its health is 0 or less. [Once health drops to zero, you are dead. This holds true for both the player and his enemies.] 

[Understand the alive property as describing a monster.]


A person has a number called permanent health. [The maximum you can regain with healing.]

When play begins:
    repeat with the patient running through people begin;
        change the permanent health of the patient to the health of the patient;
    end repeat.

[We set the permanent health of each individual to the health it has at the beginning of the game. If we wish any character to start the game wounded or super-healthy, we will have to manually override this process.]

To restore the health of (patient - a person): change the health of the patient to the permanent health of the patient. 

To heal (patient - a person) for (health - a number) health:
	let the health dummy be the permanent health of the patient minus the health of the patient;
	if health is less than the first dummy, now the health dummy is health;
	increase the health of the patient by the health dummy;
	say the health dummy.


A person has a number called gained health. [This is the amount of health the player will get when killing the character.]

When play begins:
	repeat with the patient running through people begin;
        	change the gained health of the patient to a random number between 1 and the permanent health of the patient;
[		if the patient is summoned, now the gained health of the patient is 0; ]
	end repeat.


Chapter - Basic Combat Stats

[Melee is a measure of fighting prowess. Higher melee means higher chance to hit.]

A person has a number called melee. The melee of a person is usually 0. 

[Defence is a measure of fighting prowess. Higher defence means less chance to get hit.]

A person has a number called defence. The defence of a person is usually 7.

[Damage die is the virtual die-size that we roll with when seeing how much damage a person does. If the die size is 4, the person does between 1 and 4 damage; if 8, between 1 and 8 damage; and so on.]

A person has a number called damage die. The damage die of a person is usually 6.


Chapter - Hostility

Hostility is a kind of value. The hostilities are neutral, friendly, hostile, hostile_2, hostile_3, hostile_4.

[A non-combatant should be neutral: he does not attack and does not defend. The player should be friendly, and so should his allies. Monsters should be hostile. Hostile_2, hostile_3 and hostile_4 allow for monsters that fight amongst each other and fight the player.]

A person has a hostility. The hostility of a person is usually neutral.

The hostility of the player is friendly.


Chapter - Monster

A monster is a kind of person. The hostility of a monster is usually hostile.



Book - Combat Round Preliminaries

Chapter - The pressing relation

[Pressing is mostly just a way to remember who had been attacking whom. The AI prefers continuing to attack the same person. You also get an initiative penalty for being pressed by many people.]

Pressing relates various people to various people. The verb to press (he presses, they press, he pressed, it is pressed, he is pressing) implies the pressing relation.

[This routine takes care of the pressing relations]

To have (A - a person) start pressing (B - a person):
	repeat with X running through all persons pressed by A:
		now A does not press X;
	now A presses B.

Chapter - Initiative

[The initiative modifier influences how early in the combat round someone can take an action.]

A person has a number called the initiative modifier. The initiative modifier of a person is usually 0.

An aftereffects rule (this is the modify initiative based on combat results rule):
	if the final damage is greater than 0 begin;
		decrease the initiative modifier of the global defender by the final damage;
	otherwise;
		decrease the initiative modifier of the global attacker by 2;
	end if.

 Carry out an actor waiting:
	increase the initiative modifier of the actor by 2.
	

Chapter - Combat States

[A person can have three combat states: None, Acted, React. These have the following meanings:

None: the person still has to get a turn, and can do anything when the turn comes.
Acted: the person has already taken a turn.
React: the person must act now.]

Combat state is a kind of value. The combat states are None, Acted and React.

A person has a combat state. The combat state of a person is usually None.

[A person can have three react states: NoReact, Defensive and Aggressive.

Defensive: the person did something like dodge or parry when he had to react; this gives a bonus.
Aggressive: the person counterattacked when he had to react; this increases risk.]

React state is a kind of value. The react states are No React, Defensive and Aggressive.

A person has a react state. The react state of a person is usually No React.

An always-present attack modifiers rule (this is the defensive move bonus rule):
	if the react state of the global defender is defensive begin;
		if the numbers boolean is true, say " - 1 (defensive move)[run paragraph on]";
		decrease the to-hit modifier by 1;
		now the react state of the global defender is No React;
	end if.

A damage modifiers rule (this is the counterattack extra damage rule):
	if the react state of the global attacker is aggressive or the react state of the global defender is aggressive begin;
		if the numbers boolean is true, say " + 3 (both attacking)[run paragraph on]";
		increase the damage modifier by 3;
		now the react state of the global attacker is No React;
		now the react state of the global defender is No React;
	end if.

[A person has a number called the combat move bonus. This ]


Book - The Combat Round

[The main thing here is to: (1) decide in which order people can go; (2) call everyone's AI in order to make them do something; (3) calculate the preliminary results of each action and store all future actions; (4) once everyone has had their turn, go through the stored actions.]

Chapter - Setting up the Combat Round

[(1) decide in which order people can go.]

When play begins (this is the first combat round rule):
	set up the combat order.

First turn sequence rule (this is the begin the combat round rule):
	set up the combat order.

Table of Combat Order
Combatant	       Move Order
a person			a number
with 50 blank rows

To set up the combat order:
	repeat through the Table of Combat Order:
		blank out the whole row;
	repeat with X running through all alive persons enclosed by the location:
		choose a blank row in Table of Combat Order;
		now the Combatant entry is X;
		[say "[X]: "; [Test]]
		now the Move Order entry is the number of persons pressing X;
		[say "[Move Order entry]"; [Test]]
		decrease the Move Order entry by the initiative modifier of X;
		[say "[Move Order entry]"; [Test]]
		increase the Move Order entry by a random number between 1 and 3;
		[say "[Move Order entry]"; [Test]]
		now the combat state of X is None;
		now the react state of X is No React;
		now the initiative modifier of X is 0;
	sort the Table of Combat Order in random order;
	sort the Table of Combat Order in Move Order order.

Chapter - Taking Actions (part I)

[This is slightly tricky, since we have to do part of this before, and part of it after the player has taken a turn. So we start running through the list until we get to the player, then stop.]

Last turn sequence rule:
	[say "=== NEW ROUND ===";]
	repeat with M running from 1 to the number of rows in the Table of Combat Order:
		if there is a combatant in row M of the Table of Combat Order:
			choose row M in the Table of Combat Order;
			if the combatant entry is the player, stop;
			unless the combat state of the combatant entry is Acted:
				now the global attacker is the combatant entry;
				if the global attacker is alive, consider the combat AI rulebook of the global attacker;
				now the combat state of the combatant entry is Acted;
				if the combat state of the player is React, stop;
				while there are reactionaries, have a reaction;
				run the combat.


Section - Reacting

To decide whether there are reactionaries:
	repeat with X running through alive persons enclosed by the location begin;
		if the combat state of X is React, decide yes;
	end repeat;
	decide no.

To have a reaction:
	repeat with N running from 1 to the number of rows in the Table of Combat Order:
		choose row N in the Table of Combat Order;
		if there is combatant in row N of the Table of Combat Order:
			if the combat state of the combatant entry is React:
				now the global attacker is the combatant entry;
				if the global attacker is the player:
					stop;
				if the global attacker is alive, consider the combat AI rulebook of the global attacker;
				now the combat state of the global attacker is Acted.


Chapter - Taking Actions (part II)

[Now we go on until everybody has acted.]

Every turn: 
	now the combat state of the player is acted;
	now the global attacker is the player;
	while there are reactionaries, have a reaction;
	run the combat;
	repeat with M running from 1 to the number of rows in the Table of Combat Order:
		if there is a combatant in row M of the Table of Combat Order:
			choose row M in the Table of Combat Order;
			unless the combat state of the combatant entry is Acted:
				now the global attacker is the combatant entry;
				if the global attacker is alive, consider the combat AI rulebook of the global attacker;
				now the combat state of the combatant entry is Acted;
				while there are reactionaries, have a reaction;
				run the combat.



Chapter - Run the Combat

The fight consequences variable is a truth state that varies. The fight consequences variable is false.

Table of Stored Combat Actions
Combat Speed		Combat Action
a number				a stored action
with 50 blank rows

To run the combat:
	now the fight consequences variable is true;
	sort the Table of Stored Combat Actions in Combat Speed order;
	repeat through the Table of Stored Combat Actions:
		try the Combat Action entry;
		blank out the whole row;
	now the fight consequences variable is false.




Book - Striking a Blow



Chapter - Striking a blow

The global attacker is a person that varies.
The global defender is a person that varies.

A weapon is a kind of thing. A weapon is either readied or not readied. A weapon is usually not readied.

The global attacker weapon is a weapon that varies.
The global defender weapon is a weapon that varies.

The to-hit roll is a number that varies. The to-hit modifier is a number that varies. The damage is a number that varies. The damage modifier is a number that varies. The final damage is a number that varies.

The global flavour text boolean is a truth state that varies. The global flavour text boolean is usually false.

The reset combat variables is a rulebook.
The whether attacking begins is a rulebook.
The preliminary results of attacking is a rulebook.
The basic attack roll is a rulebook.
The whether attack modifiers apply is a rulebook.
The attack modifiers is a rulebook.
The always-present attack modifiers is a rulebook.
The show results of the attack roll is a rulebook.
The whether the attack hit is a rulebook.
The immediate results of hitting is a rulebook.
The basic damage roll is a rulebook.
The damage modifiers is a rulebook.
[The always-present damage modifiers is a rulebook.]
The printing-the-damage is a rulebook.
The final damage rules is a rulebook.
The report no final damage is a rulebook.
The non-fatal damage is a rulebook.
The fatal damage is a rulebook.
The take away until attack bonuses is a rulebook.
The print flavour text is a rulebook.
The aftereffects is a rulebook.
The final blow report is a rulebook.

To make (attacker - a person) strike a blow against (defender - a person):
	now the global attacker is the attacker;
	now the global defender is the defender;
	have the global attacker start pressing the global defender;
	now the global attacker weapon is a random readied weapon enclosed by the global attacker;
	now the global defender weapon is a random readied weapon enclosed by the global defender;
	consider the reset combat variables rules;
	abide by the whether attacking begins rules; [Stage 1: Whether attacking begins]
	consider the preliminary results of attacking rules; [Stage 2: Preliminary results of attacking]
	consider the basic attack roll rules; [Stage 3: Basic attack roll]
	consider the whether attack modifiers apply rules; [Stage 4: Do attack modifiers apply?]
	if rule succeeded, consider the attack modifiers rules;[Stage 5: Apply attack modifiers]
	consider the always-present attack modifiers rules; [Stage 6: Apply attack modifiers that always apply, for instance even when getting a free bonus attack from the cleave ability]
	consider the show results of the attack roll rules; [Stage 7: show results of the attack roll]
	consider the whether the attack hit rules; [Stage 8: check and report whether we hit]
	if rule succeeded begin;
		consider the immediate results of hitting rules; [Stage 9: stage for some special effects]
		consider the basic damage roll rules; [Stage 10: roll the die for damage]
		consider the damage modifiers rules; [Stage 11: add or subtract modifiers]
		[		consider the always-present damage modifiers rules;] [Probably useless]
		if the damage is greater than 0, consider the final damage rules; [Stage 12: calculate final damage]
		consider the printing-the-damage rules; [Stage 13: print the damage]
		if the final damage is 0, consider the report no final damage rules; [Stage 14: report no damage]
		if the final damage is greater than 0 begin;
			if the final damage is less than the health of the global defender begin;
				consider the non-fatal damage rules; [Stage 14: report and apply non-fatal damage]
			otherwise;
				consider the fatal damage rules; [Stage 14: report and apply fatal damage]
			end if;
		end if;
	end if;
	consider the print flavour text rules; [Stage 15: flavour text]
	if the player is not killed, consider the aftereffects rulebook; [Stage 16: aftereffects]
	consider the take away until attack bonuses rulebook;
	consider the final blow report rulebook. [Stage 17: any reporting left to be done]


Section - Reset combat variables

A reset combat variables rule (this is the standard reset combat variables rule):
	now the damage is 0; 
	now the final damage is 0;
	now the to-hit roll is 0;
	now the to-hit modifier is 0;
	now the damage modifier is 0.


Section - Basic attack roll

A basic attack roll rule (this is the standard attack roll rule):
	if the numbers boolean is true, say "[italic type]Rolling ";
	change the to-hit roll to a random number between 1 and 10;
	if the numbers boolean is true, say the to-hit roll, "[run paragraph on]".


Section - Whether attack modifiers apply

A whether attack modifiers apply rule (this is the attack modifiers apply unless something intervenes rule):
	rule succeeds.


Section - Attack modifier melee

An attack modifiers rule (this is the melee attack bonus rule):
		if the numbers boolean is true, say " + ", the melee of the global attacker, "[run paragraph on]";
		increase the to-hit modifier by the melee of the global attacker.


Section - Show results of attack roll

A show results of the attack roll rule (this is the standard result of the attack roll rule):
	increase the to-hit roll by the to-hit modifier;
	if the numbers boolean is true, say " = ", the to-hit roll, ", [run paragraph on]";


Section - Whether the attack hits

A whether the attack hit rule (this is the standard whether the attack hit rule):
	if the to-hit roll is greater than the defence of the global defender begin;
		if the numbers boolean is true begin;
			if the global attacker is the player, say "you beat "; otherwise say "[the global attacker] beats ";
			say "[possessive of global defender] defence rating of ", the defence of the global defender, ".";
		end if;
		rule succeeds;
	otherwise;
		if the numbers boolean is true begin;
			if the global attacker is the player, say "you do ";
			if the global attacker is not the player, say "[the global attacker] does ";
			say "not overcome [possessive of global defender] defence rating of ", the defence of the global defender, ".[run paragraph on]";
		end if;
		rule fails;
	end if.

Section - Basic damage roll

First basic damage roll rule (this is the standard damage roll rule):
	now the damage is a random number between 1 and the damage die of the global attacker weapon;
	if the numbers boolean is true begin;
		if the global attacker is the player, say "You deal ", damage, "[run paragraph on]";
		if the global attacker is not the player, say "[The global attacker] deals ", damage, "[run paragraph on]";
	end if.


Section - Final damage

Final damage rule (this is the basic final damage rule):
	now the final damage is the damage plus the damage modifier.


Section - Printing the damage

Printing-the-damage rule (this is the standard printing-the-damage rule):
	if the numbers boolean is true, say " = [bold type]", final damage, " damage[roman type][italic type], [run paragraph on]".



Section - Report no final damage

Report no final damage rule (this is the basic no final damage rule):
	if the numbers boolean is true begin;
		if the global defender is not the player, say "allowing [the global defender] to escape unscathed.[run paragraph on]";
		if the global defender is the player, say "allowing you to escape unscathed.[run paragraph on]";
	end if.


Section - Print flavour text

First print flavour text rule:
	if the numbers boolean is true, say "[roman type][paragraph break]".

[
Print flavour text rule (this is the basic print flavour text rule):
	say "[roman type]";
	if the global attacker is the player or the global defender is the player begin; [We only print flavour text when it's not monster vs monster, because writing appropriate texts for all monster vs monster interactions is a quadratic rather than a linear task.]
			say "[paragraph break]"; [Here we start printing the flavour text.]
		now the global flavour text boolean is true; [To ensure that (killed) is not printed.]
		if the global attacker is the player begin;
			[choose a random row from the Player Flavour Texts of the defender;]
		otherwise;
					[if the defender is the player, choose a random row from the Monster Flavour Texts of the attacker;]
		end if;
		if the global defender is killed begin;
			[if the defender is not boss, say "[Fatal Text entry]";]
		otherwise;
			[if the to-hit roll is not greater than the defence of the defender, say "[Miss Text entry]";]
						[if the to-hit roll is greater than the defence of the defender begin;
				if the final damage is greater than 0, say "[Hit Text entry]";
				if the final damage is 0, say "[Absorbed Text entry]";
			end if;]
		end if;
	end if; 
		now the global flavour text boolean is false.
]

Section - Final blow report

[Final blow report rule (this is the insert a paragraph break when needed after reporting a blow rule):
	if the global defender is not killed [or the defender is not boss], say "[paragraph break]". [Killing and boss give paragraph breaks of their own.]]

Last final blow report rule (this is the end reporting blow with paragraph break rule):
	say "[paragraph break]".





Chapter - Calculating damage

[First damage modifiers rule (this is the temp rule):
	if the cleave boolean is false begin; [No extra attack bonus when cleaving]
		if the attack state is not fiery begin; [Things that do not work with touch attacks]
			say ""; [Currently useless! Have to think about it.]
		end if;
				if the damage bonus of the global attacker is not 0 begin;
			increase the damage modifier by the damage bonus of the global attacker;
			say " + ", damage bonus of the global attacker, " (inherent damage bonus)";
		end if;
		if the deadly combat bonus is not 0 begin;
			increase the damage modifier by the deadly combat bonus;
						if the deadlier combat boolean is true, increase the damage modifier by the deadly combat bonus;
			if the deadlier combat boolean is false, say " + ", deadly combat bonus, " (deadly combat)";
			if the deadlier combat boolean is true, say " + ", 2 times the deadly combat bonus, " (deadlier combat)";
		end if;
		if the beat is not 0 and the beat count is 0 and the beat strength is not 0 begin;
			increase the damage modifier by the beat strength;
						say " + ", beat strength, " (beat)";
		end if;
		calculate the excitement damage bonus of the global attacker;
		if the sacrificial number of the global attacker is greater than 0 begin;
			say " + ", the sacrificial number of the global attacker, " (sacrifice)";
						increase the damage modifier by the sacrificial number of the global attacker;
			now the sacrificial number of the global attacker is 0;
		end if;
		if the damage await bonus is greater than 0 and the global attacker is the player begin;
				say " + ", the damage await bonus, " (awaiting)";
				increase the damage modifier by the damage await bonus;
						end if;
		if the global attacker is smashing, do smashing blow with global attacker and global defender;  [Smashing blow]
	end if;
	if the cleave boolean is true begin;
		if the cleave damage bonus is greater than 0, say " + ", the cleave damage bonus, " (cleave)";
		increase the damage modifier by the cleave damage bonus;
	end if;
	if the damage reduction of the global defender is not 0 begin;
		say " - ", the damage reduction of the global defender, " (inherent damage reduction)";
		decrease the damage modifier by the damage reduction of the global defender;
	end if;
	increase the damage by the damage modifier;
	say " = [bold type]", damage, "[italic type]";
	continue the activity.]



Chapter - Calculating the final damage

[Last final damage rule (this is the damage turns of deadly combat rule):
	if the final damage is greater than 0, now the deadly combat boolean is false.]


To calculate the final damage (attacker - a person) does against (defender - a person):
    [if the elda armour status of the defender is greater than 0, do elda armour with attacker and defender;]
    continue the activity.


Chapter - Non-fatal damage

Non-fatal damage rule (this is the basic non-fatal damage rule):
	decrease the health of the global defender by the final damage;
	if the numbers boolean is true begin;
		if the global defender is not the player, say "wounding [the global defender] to ", health of the global defender, " health.[run paragraph on]" ;
		if the global defender is the player, say "wounding you to ", health of the global defender, " health.[run paragraph on]";
	end if;
	let the global defender lose concentration;
	[if the attacker is the player and the defender is not non-exciting and a random chance of 1 in 20 succeeds, increase the excitement of the player;]
	[if the defender is the player and the attacker is not non-exciting and a random chance of 1 in 15 succeeds, increase the excitement of the player;].


Chapter - Fatal damage

Fatal damage rule (this is the basic fatal damage rule):
	decrease the health of the global defender by the final damage;
	if the global defender is not the player begin;
		if the numbers boolean is true, say "killing [the global defender].[run paragraph on]";
		[receive health for the global defender;]
		[if the global defender is not non-exciting and a random chance of 2 in 3 succeeds, increase the excitement of the player;]
		[if a random chance of 1 in 3 succeeds and the global defender is not non-exciting, increase the excitement of the player;]
		[now the cleave melee bonus is the to-hit roll minus the defence of the global defender;]
		[now the cleave damage bonus is 0 minus the health of the global defender;]
	end if;
	if the global defender is the player begin;
		if the numbers boolean is true, say "killing you.";
	end if.



Chapter - Receiving health after a kill

To receive health for (the victim - a person):
	now the third dummy is the permanent health of the player - the health of the player;
	now the fourth dummy is the gained health of the victim;
	if the fourth dummy is greater than the third dummy, now the fourth dummy is the third dummy;
	if the fourth dummy is greater than 0 begin;
		if the numbers boolean is true, say " [bold type](Your health increases by ", the fourth dummy;
		increase the health of the player by the fourth dummy;
		[if the beat is not 0 and the beat count is 0 and the beat strength is not 0 and the health of the player is not the permanent health of the player begin;
					now the fourth dummy is the beat strength;
			now the third dummy is the permanent health of the player - the health of the player;
			if the fourth dummy is greater than the third dummy, now the fourth dummy is the third dummy;
			increase the health of the player by the fourth dummy;
			if the fourth dummy is greater than 0, say " + ", fourth dummy, " extra beat bonus";
					end if;]
		if the numbers boolean is true, say ".)[roman type][run paragraph on]";
	end if.





Book - Standard Combat Actions


Chapter - Attacking

The block attacking rule is not listed in any rulebook.

Understand "a [thing]" as attacking.

[Does the player mean attacking a killed monster: it is unlikely.
Does the player mean attacking a hostile alive monster: it is very likely.]

A check attacking rule (this is the only attack persons rule):
	if the noun is not a person, say "Things are not your enemies." instead.

A check attacking rule (this is the only attack the living rule):
	if the noun is not alive, say "[The noun] is already dead." instead.

A check attacking rule (this is the do not attack friendly people rule):
	if the hostility of the noun is friendly, say "[The noun] is your friend, not your enemy!".

A check attacking rule (this is the do not attack neutral people rule):
	if the hostility of the noun is neutral, say "[The noun] is not your enemy.".



Carry out an actor attacking when the fight consequences variable is false:
	if the combat state of the actor is React begin;
		now the react state of the actor is aggressive;
		decrease the initiative modifier of the actor by 1;
	end if;
	consider the attack move flavour rulebook;
	choose a blank row in the Table of Stored Combat actions;
	now the Combat Speed entry is 10;
	if the combat state of the actor is React begin; [This is a counterattack]
		let n be a random number between 1 and 7;
		now the Combat Speed entry is 5 + n; [Speed between 6 and 12, therefore some chance of going before the attacker, whose speed is 10.]
	end if;
	now the Combat Action entry is the action of the actor attacking the noun;
	if the combat state of the noun is not Acted, now the combat state of the noun is React.

Carry out an actor attacking when the fight consequences variable is true:
	if the actor is alive, make the actor strike a blow against the noun.



Chapter - Concentrating

Concentrating is an action applying to nothing. Understand "concentrate" and "c" as concentrating.

A person has a number called concentration. The concentration of a person is usually 0.

Carry out an actor concentrating:
	increase the initiative modifier of the actor by 1;
	increase the concentration of the actor by 1;
	if the concentration of the actor is greater than 3, now the concentration of the actor is 3;
	now the global actor is the actor;
	if the concentration of the actor is 1, say "[CAP-actor] concentrate[s], and [is-are] now mildly concentrated.";
	if the concentration of the actor is 2, say "[CAP-actor] concentrate[s], and [is-are] now quite concentrated.";
	if the concentration of the actor is 3, say "[CAP-actor] concentrate[s], and [is-are] now maximally concentrated.".

An attack modifiers rule (this is the concentration attack modifier rule):
	if the concentration of the global attacker is greater than 0 begin;
		if the concentration of the global attacker is 1, now the first dummy is 2;
		if the concentration of the global attacker is 2, now the first dummy is 4;
		if the concentration of the global attacker is 3, now the first dummy is 8;
		[if the global attacker is at parry begin;
			increase the first dummy by the concentration of the global attacker;
			decrease the first dummy by 1; [an additional +0/+1/+2]
		end if;]
		if the numbers boolean is true, say " + ", the first dummy, " (concentration)[run paragraph on]";
		increase the to-hit modifier by the first dummy;
	end if.

A damage modifiers rule (this is the concentration damage modifier rule):
	if the concentration of the global attacker is greater than 1 begin;
		if the concentration of the global attacker is 2, now the first dummy is 2;
		if the concentration of the global attacker is 3, now the first dummy is 4;
		[		if the global attacker is at parry, increase the first dummy by 1; [another +1 bonus]]
		if the numbers boolean is true, say " + ", the first dummy, " (concentration)[run paragraph on]";
		increase the damage modifier by the first dummy;
	end if.

A non-fatal damage rule (this is the lose concentration when hit rule):
	let the global defender lose concentration.

A take away until attack bonuses rule (this is the lose concentration after attacking rule):
	[if the attack state is not free, ]now the concentration of the global attacker is 0.


To let (the defender - a person) lose concentration:
	if the concentration of the defender is 0, continue the activity;
	[	if the defender is determined begin;
		now the first dummy is a random number between 1 and 6;
		if the first dummy is not less than the final damage begin;
			say " Because you are so [bold type]determined[roman type], you do not lose your concentration![run paragraph on]";
			continue the activity;
		end if;
	end if;]
	now the concentration of the defender is 0;
	if the defender is the player, say " You lose your [bold type]concentration[roman type]![run paragraph on]";
	if the defender is not the player, say " [The defender] loses [bold type]concentration[roman type]![run paragraph on]".

To let (the defender - a person) lose concentration between brackets:
	if the concentration of the defender is 0, continue the activity;
	[	if the defender is determined begin;
		now the first dummy is a random number between 1 and 6;
		if the first dummy is not less than the final damage begin;
			say " (not making you lose your concentration, since you are so [bold type]determined[roman type])[run paragraph on]";
			continue the activity;
		end if;
	end if;]
	now the concentration of the defender is 0;
	if the defender is the player, say "(making you lose your [bold type]concentration[roman type])[run paragraph on]";
	if the defender is not the player, say "(making [the defender] lose [bold type]concentration[roman type])[run paragraph on]".


[After concentrating:
	if the concentration of the actor is 1 and a random chance of 1 in 4 succeeds, decrease the excitement of the actor;
	if the concentration of the actor is 2 and a random chance of 1 in 3 succeeds, decrease the excitement of the actor;
	if the concentration of the actor is 3 and a random chance of 1 in 2 succeeds, decrease the excitement of the actor]


Chance to win rule (this is the CTW concentration bonus rule):
	if the concentration of the global attacker is 1, increase the chance-to-win by 2;
	if the concentration of the global attacker is 2, increase the chance-to-win by 4;
	if the concentration of the global attacker is 3, increase the chance-to-win by 8.


Chapter - Parrying


Parrying is an action applying to nothing. Understand "parry" and "p" as parrying.

A person can be at parry or not at parry. A person is usually not at parry.

Carry out an actor parrying:
	increase the initiative modifier of the actor by 1;
	if the combat state of the actor is React begin;
		now the react state of the actor is defensive;
		increase the initiative modifier of the actor by 1;
	end if;
	now the actor is at parry;
	now the actor is not at dodge;
	now the global actor is the actor;
	say "[CAP-actor] strike[s] up a defensive pose.".


An always-present attack modifiers rule (this is the parry decreases to-hit rule):
	if the global defender is at parry begin;
		let n be the passive parry max of global attacker weapon;
		if the active parry max of global defender weapon is less than n, now n is the active parry max of global defender weapon;
		if the numbers boolean is true begin;
			if n is greater than 0, say " - ", n, " (defender parrying)[run paragraph on]";
			if n is 0 and active parry max of global defender weapon is 0 begin;
				say " - 0 (cannot parry with [global defender weapon])[run paragraph on]";
			otherwise;
				if n is 0, say " - 0 (cannot parry against [global attacker weapon])[run paragraph on]";
			end if;
		end if;
		decrease the to-hit modifier by n;
	end if.

[		[if the global defender is not shielded, ]now the first dummy is a random number between 0 and 4;
[		if the global defender is shielded, now the first dummy is a random number between 2 and 6;]
		if the first dummy is not 0, say " - ", first dummy, " (opponent parrying)[run paragraph on]";
		decrease the damage modifier by the first dummy;]



A take away until attack bonuses rule (this is the no longer at parry after attacking rule):
	now the global attacker is not at parry.

Chance to win rule (this is the CTW parry bonus rule):
	if the global defender is at parry begin;
		let n be the passive parry max of global attacker weapon;
		if the active parry max of global defender weapon is less than n, now n is the active parry max of global defender weapon;
		decrease the chance-to-win by n;
	end if.



Chapter - Dodging


Dodging is an action applying to nothing. Understand "dodge" and "do" as dodging.

A person can be at dodge or not at dodge. A person is usually not at dodge.

Carry out an actor dodging:
	increase the initiative modifier of the actor by 1;
	if the combat state of the actor is React, now the react state of the actor is defensive;
	now the actor is at dodge;
	now the actor is not at parry;
	now the global actor is the actor;
	say "[CAP-actor] get[s] ready for quick evasive maneuvers.".

An always-present attack modifiers rule (this is the dodging defence bonus rule):
	if the global defender is at dodge begin;
		let n be the dodgability of global attacker weapon;
		if the numbers boolean is true begin;
			if n is greater than 0, say " - ", n, " (defender dodging)[run paragraph on]";
			if n is 0, say " - 0 (cannot dodge)[run paragraph on]";
		end if;
		decrease the to-hit modifier by n;
	end if.

An attack modifiers rule (this is the dodging attack bonus rule):
	if the global attacker is at dodge begin;
		if the numbers boolean is true, say " + 1 (dodge bonus)[run paragraph on]";
		increase the to-hit modifier by 1;
	end if.

A take away until attack bonuses rule (this is the no longer at dodge after attacking rule):
	now the global attacker is not at dodge.

Chance to win rule (this is the CTW dodge bonus rule):
	if the global defender is at dodge, decrease the chance-to-win by the dodgability of the stored_weapon.





Book - Artificial Intelligence

[Our standard AI works in two stages. In the first stage, we choose a person to attack--if we were to attack. In the second stage, we decide whether to attack or whether to do something else--like concentrating, dodging, readying a weapon, and so on.]

Chapter - The Tables

Table of AI Combat Person Options
Person Option					Weight
a person						a number
with 100 blank rows

Table of AI Combat Options
Option						Weight
a stored  action				a number
with 100 blank rows

Table of AI Combat Weapon Options
Weapon Option				Weight
a weapon					a number
with 30 blank rows



Section - Blanking out the Tables

To blank out the AI Combat Options:
	repeat through the Table of AI Combat Options:
		blank out the whole row.

To blank out the AI Combat Person Options:
	repeat through the Table of AI Combat Person Options:
		blank out the whole row.

To blank out the AI Combat Weapon Options:
	repeat through the Table of AI Combat Weapon Options:
		blank out the whole row.

Section - Useful variables

Stored_row is a number that varies.

Stored_person is a person that varies.

Stored_weapon is a weapon that varies.

Stored_action is a stored action that varies.


Chapter - First Stage - Choosing a Person

Section - Rulebook

The standard AI target select rules are a rulebook.

The found-a-target boolean is a truth state that varies.

To have the AI select a target:
	blank out the AI Combat Person Options;
	now the found-a-target boolean is false;
	repeat with X running through all alive persons enclosed by the location begin;
		if the hostility of X is not neutral begin;
			if the hostility of X is not the hostility of the global attacker begin;
				now the found-a-target boolean is true;
				choose a blank Row in the Table of AI Combat Person Options;
				change Person Option entry to X;
				change Weight entry to 0;
				now stored_row is the current_row;
				now stored_person is X;
				consider the standard AI target select rules;
				[say "[Person Option entry]: [Weight entry]"; [for testing]]
			end if;
		end if;
	end repeat;
	if the found-a-target boolean is true begin;
		sort the Table of AI Combat Person Options in random order;
		sort the Table of AI Combat Person Options in reverse Weight order;
		choose row one in the Table of AI Combat Person Options;
		now the global defender is the Person Option entry;
	end if.

Section - Standard rules

A standard AI target select rule (this is the prefer targets you press rule):
	choose row stored_row in Table of AI Combat Person Options;
	if the global attacker presses stored_person, increase the Weight entry by 3.

A standard AI target select rule (this is the prefer those who press you rule):
	choose row stored_row in Table of AI Combat Person Options;
	if the stored_person presses the global attacker, increase the Weight entry by 1.

A standard AI target select rule (this is the prefer the player rule):
	choose row stored_row in Table of AI Combat Person Options;
	if the stored_person is the player, increase the Weight entry by 1.

A standard AI target select rule (this is the prefer the severely wounded rule):
	choose row stored_row in Table of AI Combat Person Options;
	if the health of stored_person times 2 is less than the permanent health of stored_person, increase the Weight entry by 2;
	if the health of stored_person times 4 is less than the permanent health of stored_person, increase the Weight entry by 4.

A standard AI target select rule (this is the prefer concentrated people rule):
	choose row stored_row in Table of AI Combat Person Options;
	increase the Weight entry by the concentration of the stored_person;
	if the concentration of the stored_person is 3, increase the Weight entry by 2.

A standard AI target select rule (this is the prefer those with good weapons rule):
	choose row stored_row in Table of AI Combat Person Options;
	let item be a random readied weapon enclosed by the stored_person;
	increase the Weight entry by the damage die of item.

A standard AI target select rule (this is the do not prefer dodgers rule):
	choose row stored_row in Table of AI Combat Person Options;
	let item be a random readied weapon enclosed by the global attacker;
	if the stored_person is at dodge, decrease the Weight entry by the dodgability of item.

A standard AI target select rule (this is the do not prefer parrying rule):
	choose row stored_row in Table of AI Combat Person Options;
	let item be a random readied weapon enclosed by the global attacker;
	let item2 be a random readied weapon enclosed by the stored_person;
	let n be the passive parry max of item;
	if the active parry max of item2 is less than n, now n is the active parry max of item2;
	if the stored_person is at parry, decrease the Weight entry by n.

[The following rule makes the actor prefer people with low defence, unless he is concentrated, in which case he prefers people with high defence. Reason: if you managed to become concentrated, you should use that bonus against otherwise tough opponents.]

A standard AI target select rule (this is the do not prefer high defence unless concentrated rule):
	choose row stored_row in Table of AI Combat Person Options;
	let n be the defence of stored_person minus the melee of the global attacker;
	if n is less than 0, now n is 0;
	let m be the concentration of the global attacker minus 1;
	increase the Weight entry by n times m. [Negative if concentration = 0; 0 is concentration is 1; positive if concentration is 2 or 3.]

A standard AI target select rule (this is the randomise the target result rule):
	choose row stored_row in Table of AI Combat Person Options;
	increase the Weight entry by a random number between 0 and 3.



Chapter - Second Stage - Choosing a Weapon

The standard AI weapon select rules are a rulebook.

To have the AI select a weapon:
	blank out the AI Combat Weapon Options;
	repeat with X running through all weapons enclosed by the global attacker begin;
		choose a blank Row in the Table of AI Combat Weapon Options;
		change Weapon Option entry to X;
		change Weight entry to 0;
		now stored_row is the current_row;
		now stored_weapon is X;
		consider the standard AI weapon select rules;
		[say "[Weapon Option entry]: [Weight entry]"; [for testing]]
	end repeat;
	sort the Table of AI Combat Weapon Options in random order;
	sort the Table of AI Combat Weapon Options in reverse Weight order;
	choose row one in the Table of AI Combat Weapon Options;
	now the stored_weapon is the Weapon Option entry. 


Section - Standard rules

A standard AI weapon select rule (this is the prefer lots of damage rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	increase the Weight entry by the damage die of the Weapon Option entry.

A standard AI weapon select rule (this is the prefer bad dodgability rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	decrease the Weight entry by the dodgability of the Weapon Option entry.

A standard AI weapon select rule (this is the prefer bad passive parry rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	decrease the Weight entry by the passive parry max of the Weapon Option entry.

A standard AI weapon select rule (this is the prefer good active parry rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	increase the Weight entry by the active parry max of the Weapon Option entry.

[Rule below: it is better to have a weapon with 2 passive parry max and 2 dodgability, than one with 4 passive parry max and 0 dodgability; because your enemy can use the weapon's weakness against you. This is reflected in the rule below.]

A standard AI weapon select rule (this is the prefer balanced parry and dodge rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	let n be the dodgability of the Weapon Option entry;
	decrease n by the passive parry max of the Weapon Option entry;
	if n is less than 0, now n is 0 minus n;
	now n is n divided by 2;
	decrease the Weight entry by n.

A standard AI weapon select rule (this is the prefer good attack bonus rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	let n be the weapon attack bonus of the Weapon Option entry;
	increase the Weight entry by n.

A standard AI weapon select rule (this is the prefer readied weapon if attacker almost dead rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if four times the health of the global attacker is less than the permanent health of the global attacker begin;
		if the Weapon Option entry is readied, increase the Weight entry by 3;
	end if.

A standard AI weapon select rule (this is the prefer readied weapon if defender almost dead rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if four times the health of the global defender is less than the permanent health of the global attacker begin;
		if the Weapon Option entry is readied, increase the Weight entry by 4;
	end if.

A standard AI weapon select rule (this is the slightly prefer readied weapon rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if the Weapon Option entry is readied, increase the Weight entry by 1.

[There is no random function here, because we don't want the AI to uselessly swap weapons.]


Chapter - Third Stage - Choosing an Action

The standard AI action select rules are a rulebook.

To have the AI select an action:
	blank out the AI Combat Options;
	consider the standard AI action select rules;
	sort the Table of AI Combat Options in random order;
	sort the Table of AI Combat Options in reverse Weight order;
	choose row one in the Table of AI Combat Options;
	now the stored_action is the Option entry. 

Section - Standard select rules

[For every possible action, there MUST be a "first" rule adding it to the table.]

First standard AI action select rule (this is the consider attacking rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker attacking the global defender;
	change the Weight entry to 5.

First standard AI action select rule (this is the consider concentrating rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker concentrating;
	change the Weight entry to 3.

First standard AI action select rule (this is the consider dodging rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker dodging;
	if the combat state of the global attacker is not React begin;
		change the Weight entry to 1;
	otherwise;
		change the Weight entry to 5;
	end if.

First standard AI action select rule (this is the consider parrying rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker parrying;
	if the combat state of the global attacker is not React begin;
		change the Weight entry to 1;
	otherwise;
		change the Weight entry to 5;
	end if.

First standard AI action select rule (this is the consider readying rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker readying the stored_weapon;
	change the Weight entry to 0.

First standard AI action select rule (this is the consider reloading rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker reloading the stored_weapon;
	change the Weight entry to 0.

Section - Calculating the chance to win

The chance to win rules is a rulebook.

The chance-to-win is a number that varies.

First standard AI action select rule (this is the calculate the chance to win rule):
	consider the chance to win rules.

First chance to win rule (this is the CTW default rule):
	now the chance-to-win is 10.

Chance to win rule (this is the CTW melee bonus rule):
	increase the chance-to-win by the melee of the global attacker.

Chance to win rule (this is the CTW defence bonus rule):
	decrease the chance-to-win by the defence of the global attacker.

[Other rules are in the appropriate sections.]

Last chance to win rule (this is the CTW no greater than 10 rule):
	if the chance-to-win is greater than 10, now the chance-to-win is 10.


Section - Standard rules

A standard AI action select rule (this is the standard attack select rule):
	choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
	if the chance-to-win is 0, change the Weight entry to -100;
	decrease the Weight entry by 5;
	increase the Weight entry by the chance-to-win.

A standard AI action select rule (this is the standard concentration select rule):
	choose row with an Option of the action of the global attacker concentrating in the Table of AI Combat Options;
	increase the Weight entry by 5;
	decrease the Weight entry by the chance-to-win;
	if the concentration of the global attacker is 3, now the weight entry is -100.

A standard AI action select rule (this is the concentration influences attacking rule):
	choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
	increase the Weight entry by the concentration of the global defender;
	if the concentration of the global defender is 3, increase the Weight entry by 2;
	[increase the weight entry by the concentration of the global attacker].

A standard AI action select rule (this is the standard parry and dodge select rule):
	repeat with X running through alive persons enclosed by the location begin;
		let d be 0;
		let p be 0;
		if X presses the global attacker begin;
			let item be a random readied weapon enclosed by X;
			increase d by the dodgability of item;
			let m be the passive parry max of item;
			if m is greater than active parry max of stored_weapon, now m is active parry max of stored_weapon;
			increase p by m;
		end if; [now we have calculated how good parrying and dodging are]
		choose row with an Option of the action of the global attacker dodging in the Table of AI Combat Options;
		increase the weight entry by d;
		if the global attacker is at parry, decrease the weight entry by 2;
		if d is not greater than p, now the weight entry is -100;
		if the global attacker is at dodge and the combat state of the global attacker is not React, now the weight entry is -100;
		choose row with an Option of the action of the global attacker parrying in the Table of AI Combat Options;
		increase the weight entry by p;
		if the global attacker is at dodge, decrease the weight entry by 2;
		[if the combat state of the global attacker is React, increase the weight entry by the concentration of the global attacker; [TODO]] [Only if I decide that parrying gets a Con bonus.]
		if d is greater than p, now the weight entry is -100;
		if stored_weapon is not readied, now the weight entry is -100;
		if the global attacker is at parry and the combat state of the global attacker is not React, now the weight entry is -100;
	end repeat.


A standard AI action select rule (this is the standard ready select rule):
	if the stored_weapon is readied begin;
		choose row with an Option of the action of the global attacker readying the stored_weapon in the Table of AI Combat Options;
		now the Weight entry is -100;
	otherwise;
		choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
		now the Weight entry is -100;
		choose row with an Option of the action of the global attacker concentrating in the Table of AI Combat Options;
		now the Weight entry is -100;
		choose row with an Option of the action of the global attacker readying the stored_weapon in the Table of AI Combat Options;
		increase the Weight entry by 5;		
	end if.

A standard AI action select rule (this is the standard reloading select rule):
	if the current shots of the stored_weapon is 0 and the maximum shots of the stored_weapon is not 0 begin;
		choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
		now the Weight entry is -100;
		choose row with an Option of the action of the global attacker concentrating in the Table of AI Combat Options;
		now the Weight entry is -100;
		choose row with an Option of the action of the global attacker reloading the stored_weapon in the Table of AI Combat Options;
		increase the Weight entry by 5;
	otherwise;
		choose row with an Option of the action of the global attacker reloading the stored_weapon in the Table of AI Combat Options;
		now the Weight entry is -100;
	end if.


Last standard AI action select rule (this is the randomise the action result rule):
	repeat through the Table of AI Combat Options begin;
		increase the Weight entry by a random number between 0 and 2;
		say "[Option entry]: [Weight entry][line break]"; [For testing]
	end repeat.



Chapter - Standard attacker AI

The standard_attacker is a rulebook.

A standard_attacker rule:
	have the AI select a target;
	if the found-a-target boolean is true begin;
		have the AI select a weapon;
		have the AI select an action;
		try the stored_action;
	end if.




Chapter - General AI definitions

A person has a rulebook called the combat AI rulebook. The combat AI rulebook of a person is usually the standard_attacker rulebook.



Book - Weapons

Chapter - The weapon kind



[A readied weapon is one that is not just carried by the actor, but actually in use.]

A weapon has a number called the damage die. The damage die of a weapon is usually 6.

[The damage die is the die size used to calculate damage.]

A weapon has a number called the dodgability. The dodgability of a weapon is usually 2.

[The dodgability of a weapon is the bonus a defender gets against it when dodging.]

A weapon has a number called the passive parry max. The passive parry max is usually 2.

[The passive parry max is the maximum bonus a defender can get when parrying AGAINST this weapon.]

A weapon has a number called the active parry max. The active parry max is usually 2.

[The active parry max is the maximum bonus a defender can get when parrying WITH this weapon.]

A weapon has a number called the weapon attack bonus. The weapon attack bonus of a weapon is usually 0.

Section - Weapon attack bonus

An attack modifiers rule (this is the attack bonus from weapon rule):
	let item be a random readied weapon enclosed by the global attacker;
	let n be the weapon attack bonus of item;
	if the numbers boolean is true begin;
		if n is greater than 0, say " + ", n, " ([item] bonus)[run paragraph on]";
		if n is less than 0, say " - ", n, " ([item] penalty)[run paragraph on]";
	end if;
	increase the to-hit modifier by n.

Chance to win rule (this is the CTW attack bonus from weapon rule):
	increase the chance-to-win by the weapon attack bonus of the stored_weapon.


Chapter - The ready action

Section - The action itself

Readying is an action applying to one touchable thing.

Understand "ready [weapon]" as readying.

Carry out an actor readying:
	if the actor encloses the noun begin;
		now the noun is readied;
		now the global actor is the actor;
		say "[CAP-actor] read[ies] [the noun].";
	otherwise;
		try the actor taking the noun;
		if the actor has the noun, now the noun is readied;
	end if;
	if the noun is readied begin;
		now the actor is not at parry;
		repeat with item running through things enclosed by the actor begin;
			if the item is not the noun and the item is readied, now the item is not readied;
		end repeat;
	end if.



After printing the name of a readied weapon while taking inventory:
	say " (readied)".

After dropping a readied weapon:
	now the noun is not readied; continue the action.

After putting on a readied weapon:
	now the noun is not readied; continue the action.

After inserting into a readied weapon:
	now the noun is not readied; continue the action.


Section - Natural weapons

A natural weapon is a kind of weapon.

A natural weapon is part of every person.

Instead of examining a natural weapon:
	say "Clenched fists, kicking feet--that kind of stuff.".

The damage die of a natural weapon is usually 3. The dodgability of a natural weapon is usually 2. The passive parry max of a natural weapon is usually 2. The active parry max of a natural weapon is usually 0.


Section - Natural weapons as a fallback option

First every turn rule (this is the ready natural weapons if no other weapon readied rule):
	repeat with X running through all alive persons enclosed by the location:
		if X encloses no readied weapon:
			let item be a random natural weapon part of X;
			now item is readied.

The ready natural weapons if no other weapon readied rule is listed in the when play begins rulebook.



Book - Reporting the Combat

Chapter - Reporting the blow

The intervening flavour text are a rulebook. [Use this to intervene in the normal procedure.]
The flavour are a rulebook. [In non-fatal cases]
The fatal player flavour are a rulebook. [When the player is killed.]
The fatal flavour are a rulebook. [When someone else is killed.]

The attack move flavour are a rulebook. [When someone attacks, before the other person reacts.]

A print flavour text rule:
	abide by the intervening flavour text rules;
	if the global defender is alive begin;
		abide by the flavour rulebook;
	otherwise;
		if the global defender is the player, abide by the fatal player flavour rulebook;
		if the global defender is not the player, abide by the fatal flavour rulebook;
	end if.
	
	Chapter - Basic rules

Last flavour rule (this is the basic flavour rule):
	if the final damage is greater than 0 begin;
		say "[CAP-attacker] hit[s] [the global defender].[run paragraph on]";
	otherwise;
		say "[CAP-attacker] miss[es] [the global defender].[run paragraph on]";
	end if;
	continue the action.

Last fatal player flavour rule (this is the basic player flavour rule):
	say "You are killed by [the global attacker].".

Last fatal flavour rule (this is the basic fatal flavour rule):
	say "[CAP-attacker] kill[s] [the global defender]." in sentence case.

Last attack move flavour rule (this is the basic attack move flavour rule):
	now the global actor is the actor;
	if the actor is not the player, say "[CAP-actor] lung[es] towards [the noun].[paragraph break]".




Volume - Subsystems


Book - Weapon Extras

Chapter - Reloading

A weapon has a number called the maximum shots. The maximum shots of a weapon is usually 0. A weapon has a number called the current shots. The current shots of a weapon is usually 0. A weapon has a number called the maximum load time. The maximum load time of a weapon is usually 0.  A weapon has a number called the current load time. The current load time of a weapon is usually 0.

Definition: a weapon is unloaded if its current shots is 0 and its maximum shots is not 0.

[Maximum shots: number of rounds the weapon can be used when fully loaded. Current shots: number of shots still loaded. Maximum load time: number of rounds it takes to load the weapon. Current load time: number of rounds it still takes to load the weapon.]

[Set maximum shots to 0 for any weapon that shouldn't use these statistics. Set maximum load time to -1 in case a weapon cannot be reloaded. NEVER set maximum load time to 0 for a weapon with maximum shots not 0.]

[The basic system does NOT deal with ammo. Everyone is assumed to have infinite ammunition.]

After printing the name of a weapon (called item) when taking inventory:
	if the maximum shots of item is not 0 begin;
		if the current shots of item is not 0 begin;
			say " ([current shots of item] of [maximum shots of item] shots left)";
		else;
			say " (no ammo; [current load time of item] rounds to reload)";
		end if;
	end if.

An aftereffects rule (this is the decrease ammo rule):
	if the maximum shots of the global attacker weapon is greater than 0 begin;
		decrease the current shots of the global attacker weapon by 1;
	end if.

Check attacking:
	let item be a random readied weapon enclosed by the player;
	if the maximum shots of item is greater than 0 begin;
		if the current shots of item is not greater than 0, say "You pull the trigger, but nothing happens--you're out of ammo!" instead;
	end if.

Reloading is an action applying to one carried thing.

Understand "reload [weapon]" as reloading.

Does the player mean reloading an unloaded readied weapon enclosed by the player: it is very likely.
Does the player mean reloading an unloaded weapon enclosed by the player: it is likely.

Check reloading:
	if the maximum shots of the noun is 0, say "[The noun] does not use ammo." instead;
	if the maximum load time of the noun is -1, say "[The noun] cannot be reloaded." instead;
	if the current shots of the noun is the maximum shots of the noun, say "[The noun] is already loaded." instead.

Carry out an actor reloading:
	now the noun is readied;
	decrease the current load time of the noun by 1;
	now the global actor is the actor;
	if the current load time of the noun is 0 begin;
		say "[CAP-actor] [if the maximum load time of the noun is 1]reload[s][otherwise]finish[es] reloading[end if] [the noun].";
		now the current shots of the noun is the maximum shots of the noun;
		now the current load time of the noun is the maximum load time of the noun;
	otherwise;
		say "[CAP-actor] [if the current shots of the noun is not 0]discard[s] the old ammo, and [end if][if the current load time of the noun plus 1 is the maximum load time of the noun]start[s][otherwise]continue[s][end if] reloading [the noun].";
		now the current shots of the noun is 0;
	end if.


Section - Reloading and choosing a weapon

[Weapons with high load times and limited ammo should not be given a penalty if they are already readied and full; some penalty if they are not readied; and a larger penalty if they are not readied and out of ammo.]

Last standard AI weapon select rule (this is the do not prefer low ammo and long reload rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if the Weapon Option entry is readied and the current shots of the Weapon Option entry is greater than 0 begin;
		increase the Weight entry by 0;
	otherwise;
		let n be the Weight entry;
		let m be the maximum shots of the Weapon Option entry;
		let m be m + 1;
		let n be n times m;
		let m be m + the maximum load time of the Weapon Option entry;
		if the maximum load time of the Weapon Option entry is -1, increase m by 1;
		let n be n divided by m; [Weight * shots / (shots + reload) = Weight * percentage of useful turns. We add 1 to the shots in order to compensate for turns spent concentrating, defending, or so on.]
		now the Weight entry is n;
		if the current shots of the Weapon Option entry is less than 1, decrease the Weight entry by 1;
		if the current shots of the Weapon Option entry is less than 2, decrease the Weight entry by 1;
	end if.

[Weapons with 0 ammo and a maximum load time of -1 should NOT be chosen.]

Last standard AI weapon select rule (this is the do not chose an empty weapon that cannot be reloaded rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if the maximum shots of the Weapon Option entry is 0 begin;
		if the maximum load time of the Weapon Option entry is -1, now the Weight entry is -100;
	end if.







[HERE START GAME-SPECIFIC ADDITIONS TO INFORM ATTACK]



Chapter - Swords and spears

A sword is a kind of weapon. A spear is a kind of weapon.

The weapon attack bonus of a sword is usually 0. The damage die of a sword is usually 6. The dodgability of a sword is usually 1. The passive parry max of a sword is usually 2. The active parry max of a sword is usually 3.


The weapon attack bonus of a spear is usually 2. The damage die of a spear is usually 8. The dodgability of a spear is usually 3. The passive parry max of a spear is usually 0. The active parry max of a spear is usually 0.

Instead of examining a spear: say "Bronze-tipped and eight feet long.[paragraph break][stats of the noun][if the numbers boolean is true][italic type]Special effects:[roman type] none[otherwise]It has no special effects[end if].".


Chapter - To show stats

To say stats of (the item - an object):
	if the numbers boolean is true:
		say "[i]Attack bonus:[r] [weapon attack bonus of the item][lb][i]Damage die:[r] [damage die of the item][lb][i]Dodgability:[r] [dodgability of the item][lb][i]Passive parry max:[r] [passive parry max of the item][lb][i]Active parry max:[r] [active parry max of the item][lb]";
	otherwise:
		say "The attack bonus of [the item] is [b][if the weapon attack bonus of the item is less than -1]very bad[else if the weapon attack bonus of the item is -1]bad[else if the weapon attack bonus of the item is 0]normal[else if the weapon attack bonus of the item is 1]good[else if the weapon attack bonus of the item is 2]very good[else if the weapon attack bonus of the item is greater than 2]fantastic[end if][r], ";
		say "and its damage is [b][if the damage die of the item is less than 5]very low[else if the damage die of the item is 5]low[else if the damage die of the item is 6]average[else if the damage die of the item is 7]above average[else if the damage die of the item is 8]high[else if the damage die of the item is 9]very high[else if the damage die of the item is greater than 9]incredible[end if][r]. ";
		say "It is [b][if the dodgability of the item is less than 0]very hard[else if the dodgability of the item is 0]hard[else if the dodgability of the item is 1]quite hard[else if the dodgability of the item is 2]normally difficult[else if the dodgability of the item is 3]easy[else if the dodgability of the item is greater than 3]very easy[end if][r] to dodge, ";
		say "and [b][if the passive parry max of the item is less than 0]very hard[else if the passive parry max of the item is 0]hard[else if the passive parry max of the item is 1]quite hard[else if the passive parry max of the item is 2]normally difficult[else if the passive parry max of the item is 3]easy[else if the passive parry max of the item is greater than 3]very easy[end if][r] to parry against. ";
		say "In addition, it is a[b][if the active parry max of the item is less than 1] very bad[else if the active parry max of the item is 1] bad[else if the active parry max of the item is 2][r]n[b] average[else if the active parry max of the item is 3] good[else if the active parry max of the item is greater than 3][r]n[b] excellent[end if][r] weapon to parry with. ".



Chapter - New actions

Section - Charging

[There is no player command that leads to a charge; only the boar can charge.]

Charging is an action applying to one thing.

First standard AI action select rule (this is the consider charging rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker charging the global defender;
	change the Weight entry to -100.

The charge boolean is a truth state that varies. The charge boolean is false.

Carry out an actor charging:
	now the charge boolean is true;
	try the actor attacking the noun;
	now the charge boolean is false.



[HERE STARTS THE GAME PROPER]


Section - The chorus

The chorus is a backdrop. The chorus is everywhere.

Understand "we" and "you" and "chorus" and "bearers" and "libation" and "maidens" and "maiden" as the chorus.

Instead of examining the chorus for the first time:
	say "Hi, Orestes! We are your very own chorus of libation bearers, and cute-looking maidens to boot.".

Instead of examining the chorus:
	say "We wave and smile at you. You are our hero!".


Part - Palace of Phocis
	

Chapter - Your room
	
Your room is a room. "Here you have slept away the years of injustice. Now only the large chest in the corner interests you, and the door leading south to the rest of the Palace of Phocis."

The player is in your room.

The large chest is in your room. It is an openable closed locked container. The large chest is scenery.


Your sword is a sword. Your sword is in your room. "Your sword stands against the wall, beckoning." Instead of examining your sword: say "It is as sharp as any piece of iron you are likely to find.[paragraph break][stats of your sword][if the numbers boolean is true][italic type]Special effects:[roman type] none[otherwise]It has no special effects[end if].".

In your room is a spear.

Check going south from your room:
	if courtyard is unvisited:
		if your sword is not enclosed by the player:
			say "How could you leave without your sword, Orestes?" instead;
		if your sword is not readied:
			say "It is a dangerous world, Orestes. You should ready your sword.[lb][i]To ready a weapon, type 'ready' followed by the name of the weapon. When you attack, you will always use your readied weapon. If you have no weapon readied, you will attack with your bare hands--not a very strategic choice. You can check which weapon is readied by taking inventory[r]." instead;
		otherwise:
			run a conversation from set_values_1;
			say "Helios dazzles you as you step outside into the courtyard. We follow you.".

set_values_1, set_values_2, set_values_3, set_values_4, set_values_5, set_values_6 are chat nodes.

Instead of giving text for set_values_1: say "Tell us, Orestes, how difficult do you want your adventure to be?".
Instead of finding responses to set_values_1: link to set_values_2; link to set_values_3; link to set_values_4.

Instead of giving link to set_values_2: say "I want to go on a [b]power trip[r], slaughtering my enemies without having to face the possibility of defeat!".
Instead of giving text for set_values_2:
	now the permanent health of the player is 20;
	now the health of the player is 20;
	now the melee of the player is 3;
	now the defence of the player is 9;
	say "And would you like to see all the numbers involved in tactical combat, or just the prose descriptions?".
Instead of finding responses to set_values_2: link to set_values_5; link to set_values_6.

Instead of giving link to set_values_3: say "I want to have a [b]fair fight[r], feeling the exhilaration of achievement while being assured of continuous progress!".
Instead of giving text for set_values_3:
	now the permanent health of the player is 14;
	now the health of the player is 14;
	now the melee of the player is 1;
	now the defence of the player is 7;
	say "And would you like to see all the numbers involved in tactical combat, or just the prose descriptions?".
Instead of finding responses to set_values_3: link to set_values_5; link to set_values_6.

Instead of giving link to set_values_4: say "I want to play [b]hard core[r], so I can rejoice in my superiority when I look down on the corpses of my enemies!".
Instead of giving text for set_values_4:
	now the permanent health of the player is 10;
	now the health of the player is 10;
	now the melee of the player is 0;
	now the defence of the player is 6;
	say "And would you like to see all the numbers involved in tactical combat, or just the prose descriptions?".
Instead of finding responses to set_values_4: link to set_values_5; link to set_values_6.

Instead of giving link to set_values_5: say "Numbers scare me! I am a casual gamer!".
Instead of giving text for set_values_5: try switching the numbers off; say "Very well. You can always switch by typing [i]numbers off[r] and [i]numbers on[r].[pb][pb]".

Instead of giving link to set_values_6: say "I don't understand. How can I min-max without numbers?".
Instead of giving text for set_values_6: try switching the numbers on; say "Very well. You can always switch by typing [i]numbers off[r] and [i]numbers on[r].[pb][pb]".




Chapter - Courtyard

Courtyard is south of your room. "The entrance gate of the palace lies west, while the gallery that leads to the megaron is east. You can access your room to the north."


Chapter - Entrance Gate

Entrance Gate is west of Courtyard. "The gate. Lions."

The assassin is a person. The assassin is in Entrance Gate. The assassin is hostile.



Chapter - Megaron

Megaron is east of the courtyard. "A description of the megaron will be shown here."


Section - The boar

The boar is an animal. The boar is in Megaron. The boar is hostile.

[The boar's stats]

The health of the boar is 14.
The melee of the boar is 4.
The defence of the boar is 8.

The damage die of the boar's natural weapon is 6. The dodgability of the boar's natural weapon is 2. The passive parry max of the boar's natural weapon is 1. The active parry max of the boar's natural weapon is 2.


[The boar has a special charge attack.]


A standard AI action select rule (this is the boar charge select rule):
	if the global attacker is the boar:
		choose row with an Option of the action of the global attacker charging the global defender in the Table of AI Combat Options;
		increase the Weight entry by 107.
		
An attack modifiers rule (this is the charge attack modifier rule):
	if the charge boolean is true:
		say " + 2 (charging)[run paragraph on]";
		increase the to-hit modifier by 2.


A damage modifiers rule (this is the charge damage modifier rule):
	if the charge boolean is true:
		say " + 4 (charging)[run paragraph on]";
		increase the damage modifier by 4.



Test boar with "take sword / ready sword / south / 2 / 2 / east".




